IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Filter_Movement_Iens]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Filter_Movement_Iens]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author		:	PII
-- Created date	:	12/18/2012
-- Description	:	Gets all movements for the date interval.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Filter_Movement_Iens] 
	@START_DATE DATETIME,
	@END_DATE DATETIME,
	@VISTA_SITE_UID UNIQUEIDENTIFIER
AS
BEGIN
	SET NOCOUNT ON;

	SELECT ID, IEN, DATE_TIME, PATIENT_UID, CODE AS TYPE_OF_MOVEMENT_CODE, TRANSACTION_ID, CURRENT_ADMISSION_IEN, ENTERED_DATE
	FROM
		(SELECT AE.ID, AE.IEN, AE.ADMISSION_DATE AS DATE_TIME, AE.PATIENT_UID, C.CODE, '1' AS TRANSACTION_ID, AE.IEN AS CURRENT_ADMISSION_IEN, AE.ENTERED_DATE
		FROM ADMISSION_EVN AS AE
			LEFT JOIN CONCEPT AS C ON AE.TYPE_OF_MOVEMENT_ID = C.ID
		WHERE AE.VISTA_SITE_UID = @VISTA_SITE_UID AND AE.ADMISSION_DATE BETWEEN @START_DATE AND @END_DATE
		UNION ALL
		SELECT ME.ID, ME.IEN, ME.MOVEMENT_DATE AS DATE_TIME, ME.PATIENT_UID, C.CODE, '2' AS TRANSACTION_ID, AE.IEN AS CURRENT_ADMISSION_IEN, ME.ENTERED_DATE
		FROM MOVEMENT_EVN AS ME
			LEFT JOIN CONCEPT AS C ON ME.TYPE_OF_MOVEMENT_ID = C.ID
			LEFT JOIN ADMISSION_EVN AS AE ON ME.ADMISSION_ID = AE.ID
		WHERE ME.VISTA_SITE_UID = @VISTA_SITE_UID AND ME.MOVEMENT_DATE BETWEEN @START_DATE AND @END_DATE
		UNION ALL
		SELECT ST.ID, ST.IEN, ST.DATE_TIME, ST.PATIENT_UID, C.CODE, '6' AS TRANSACTION_ID, AE.IEN AS CURRENT_ADMISSION_IEN, ST.ENTERED_DATE
		FROM SPECIALTY_TRANSFER AS ST
			LEFT JOIN CONCEPT AS C ON ST.TYPE_OF_MOVEMENT_ID = C.ID
			LEFT JOIN ADMISSION_EVN AS AE ON ST.ADMISSION_ID = AE.ID
		WHERE ST.VISTA_SITE_UID = @VISTA_SITE_UID AND ST.DATE_TIME BETWEEN @START_DATE AND @END_DATE
		UNION ALL
		SELECT DE.ID, DE.IEN, DE.DISCHARGED_DATE AS DATE_TIME, DE.PATIENT_UID, C.CODE, '3' AS TRANSACTION_ID, AE.IEN AS CURRENT_ADMISSION_IEN, DE.ENTERED_DATE
		FROM DISCHARGE_EVN AS DE
			LEFT JOIN CONCEPT AS C ON DE.TYPE_OF_MOVEMENT_ID = C.ID
			LEFT JOIN ADMISSION_EVN AS AE ON DE.ADMISSION_ID = AE.ID
		WHERE DE.VISTA_SITE_UID = @VISTA_SITE_UID AND DE.DISCHARGED_DATE BETWEEN @START_DATE AND @END_DATE) A
	ORDER BY CAST(IEN AS BIGINT)
	
END
GO